 ; Ŀ
 ;   VBMR - middle right rejustify a column of text.                       
 ;   Copyright 1995, 1997, 2008 by Rocket Software Ltd.                    
 ;                                                                         
 ; 
 (DEFUN C:VBMR (/ ss xa entt txang obliq dnang xb num enam pa typ txht pelv pb
                                                                         ll sp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (prompt "Pick text strings to MR rejustify: ")
  (if (setq ss (ssget '((-4 . "<or")
                        (0 . "text")
                        (0 . "attdef")
                        (-4 . "or>"))))
      (progn
           (setq xa (getpoint "Pick the middle right side: "))
 ; Ŀ
 ;   Use the text angle of the first text entity as the angle for all.     
 ; 
           (setq entt (entget (ssname ss 0)))
           (setq txang (cdr (assoc 50 entt)))
           (if (null (setq obliq (cdr (assoc 51 entt))))
               (setq obliq 0))
           (setq dnang (- txang (/ pi 2) obliq))
           (setq xb (polar xa dnang 100))
 ; Ŀ
 ;   For each entity find its angle and the intersection of its baseline   
 ;   with a line from xa at dnang, the text down angle, and move it there. 
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (setq pa (cdr (assoc 10 entt)))
 ; Ŀ
 ;   Convert the entity to middle right justified.                         
 ; 
                  (setq typ (cdr (assoc 0 entt)))
                  (if (= typ "TEXT")
                      (if (assoc 73 entt)
                          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
                          (setq entt (append entt (list (cons 73 2)))))
                      (if (assoc 74 entt)
                          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
                          (setq entt (append entt (list (cons 74 2))))))
                  (entmod (subst (cons 72 2) (assoc 72 entt) entt))
 ; Ŀ
 ;   Move it back to the original location.                                
 ; 
                  (setq entt (entget enam))
                  (setq txht (cdr (assoc 40 entt)))
                  (setq txang (cdr (assoc 50 entt)))
                  (setq pelv (polar pa (+ txang (/ pi 2)) (/ txht 2)))
                  (entmod (subst (cons 11 pelv) (assoc 11 entt) entt))
 ; Ŀ
 ;   Move it into the correct location along its own horizontal axis.      
 ; 
                  (setq entt (entget enam))
                  (setq pa (cdr (assoc 11 entt)))
                  (setq pb (polar pa txang 100))
                  (setq ll (inters xa xb pa pb nil))
                  (entmod (subst (cons 11 ll) (assoc 11 entt) entt)))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
           (setq sp (if (= (setq num (sslength ss)) 1) "" "s"))
           (prompt (strcat "\n" (itoa num) " line" sp " mled.")))
      (prompt "\nNo text selected."))
  (command ".undo" "end")
 (princ))